import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { FacingMaster } from '../models';
import { FacingMasterRepository } from '../repositories';
export declare class FacingMasterController {
    facingMasterRepository: FacingMasterRepository;
    constructor(facingMasterRepository: FacingMasterRepository);
    create(facingMaster: Omit<FacingMaster, 'facingId'>): Promise<FacingMaster>;
    count(where?: Where<FacingMaster>): Promise<Count>;
    find(filter?: Filter<FacingMaster>): Promise<FacingMaster[]>;
    updateAll(facingMaster: FacingMaster, where?: Where<FacingMaster>): Promise<Count>;
    findById(id: number, filter?: FilterExcludingWhere<FacingMaster>): Promise<FacingMaster>;
    updateById(id: number, facingMaster: FacingMaster): Promise<void>;
    replaceById(id: number, facingMaster: FacingMaster): Promise<void>;
    deleteById(id: number): Promise<void>;
}
