import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { CityMaster } from '../models';
import { CityMasterRepository } from '../repositories';
export declare class CityMasterController {
    cityMasterRepository: CityMasterRepository;
    constructor(cityMasterRepository: CityMasterRepository);
    create(cityMaster: Omit<CityMaster, 'cityId'>): Promise<CityMaster>;
    count(where?: Where<CityMaster>): Promise<Count>;
    find(filter?: Filter<CityMaster>): Promise<CityMaster[]>;
    updateAll(cityMaster: CityMaster, where?: Where<CityMaster>): Promise<Count>;
    findById(id: number, filter?: FilterExcludingWhere<CityMaster>): Promise<CityMaster>;
    updateById(id: number, cityMaster: CityMaster): Promise<void>;
    replaceById(id: number, cityMaster: CityMaster): Promise<void>;
    deleteById(id: number): Promise<void>;
}
