/// <reference types="express" />
import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { Request } from '@loopback/rest';
import { BuyerMaster } from '../models';
import { BuyerMasterRepository } from '../repositories';
export declare class BuyermasterController {
    buyerMasterRepository: BuyerMasterRepository;
    constructor(buyerMasterRepository: BuyerMasterRepository);
    create(buyerMaster: Omit<BuyerMaster, 'buyerId'>): Promise<BuyerMaster>;
    createWithFile(request: Request, response: any): Promise<BuyerMaster>;
    count(where?: Where<BuyerMaster>): Promise<Count>;
    find(filter?: Filter<BuyerMaster>): Promise<BuyerMaster[]>;
    findById(id: number, filter?: FilterExcludingWhere<BuyerMaster>): Promise<BuyerMaster>;
    updateByIdWithFile(id: number, request: Request, response: any): Promise<BuyerMaster>;
    deleteById(id: number): Promise<void>;
    softDelete(id: number): Promise<BuyerMaster>;
}
