"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BestpropertymasterController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let BestpropertymasterController = class BestpropertymasterController {
    constructor(bestPropertyMasterRepository) {
        this.bestPropertyMasterRepository = bestPropertyMasterRepository;
    }
    async create(bestPropertyMaster) {
        return this.bestPropertyMasterRepository.create(bestPropertyMaster);
    }
    async count(where) {
        return this.bestPropertyMasterRepository.count(where);
    }
    async find(filter) {
        return this.bestPropertyMasterRepository.find(filter);
    }
    async updateAll(bestPropertyMaster, where) {
        return this.bestPropertyMasterRepository.updateAll(bestPropertyMaster, where);
    }
    async findById(id, filter) {
        return this.bestPropertyMasterRepository.findById(id, filter);
    }
    async updateById(id, bestPropertyMaster) {
        await this.bestPropertyMasterRepository.updateById(id, bestPropertyMaster);
    }
    async replaceById(id, bestPropertyMaster) {
        await this.bestPropertyMasterRepository.replaceById(id, bestPropertyMaster);
    }
    async deleteById(id) {
        await this.bestPropertyMasterRepository.deleteById(id);
    }
};
exports.BestpropertymasterController = BestpropertymasterController;
tslib_1.__decorate([
    (0, rest_1.post)('/best-property-masters'),
    (0, rest_1.response)(200, {
        description: 'BestPropertyMaster model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.BestPropertyMaster) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.BestPropertyMaster, {
                    title: 'NewBestPropertyMaster',
                    exclude: ['bestPropertyId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], BestpropertymasterController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/best-property-masters/count'),
    (0, rest_1.response)(200, {
        description: 'BestPropertyMaster model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.BestPropertyMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], BestpropertymasterController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/best-property-masters'),
    (0, rest_1.response)(200, {
        description: 'Array of BestPropertyMaster model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.BestPropertyMaster, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.BestPropertyMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], BestpropertymasterController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/best-property-masters'),
    (0, rest_1.response)(200, {
        description: 'BestPropertyMaster PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.BestPropertyMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.BestPropertyMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.BestPropertyMaster, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], BestpropertymasterController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/best-property-masters/{id}'),
    (0, rest_1.response)(200, {
        description: 'BestPropertyMaster model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.BestPropertyMaster, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.BestPropertyMaster, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], BestpropertymasterController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/best-property-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'BestPropertyMaster PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.BestPropertyMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.BestPropertyMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], BestpropertymasterController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/best-property-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'BestPropertyMaster PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.BestPropertyMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], BestpropertymasterController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/best-property-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'BestPropertyMaster DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], BestpropertymasterController.prototype, "deleteById", null);
exports.BestpropertymasterController = BestpropertymasterController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.BestPropertyMasterRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.BestPropertyMasterRepository])
], BestpropertymasterController);
//# sourceMappingURL=bestpropertymaster.controller.js.map