"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BestpropertylaunchController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let BestpropertylaunchController = class BestpropertylaunchController {
    constructor(bestpropertyLaunchRepository) {
        this.bestpropertyLaunchRepository = bestpropertyLaunchRepository;
    }
    async create(bestpropertyLaunch) {
        return this.bestpropertyLaunchRepository.create(bestpropertyLaunch);
    }
    async count(where) {
        return this.bestpropertyLaunchRepository.count(where);
    }
    async find(filter) {
        return this.bestpropertyLaunchRepository.find({
            include: [{ relation: 'postproperty' }],
            ...filter,
        });
    }
    async updateAll(bestpropertyLaunch, where) {
        return this.bestpropertyLaunchRepository.updateAll(bestpropertyLaunch, where);
    }
    async findById(id, filter) {
        return this.bestpropertyLaunchRepository.findById(id, filter);
    }
    async updateById(id, bestpropertyLaunch) {
        await this.bestpropertyLaunchRepository.updateById(id, bestpropertyLaunch);
    }
    async replaceById(id, bestpropertyLaunch) {
        await this.bestpropertyLaunchRepository.replaceById(id, bestpropertyLaunch);
    }
    async deleteById(id) {
        await this.bestpropertyLaunchRepository.deleteById(id);
    }
};
exports.BestpropertylaunchController = BestpropertylaunchController;
tslib_1.__decorate([
    (0, rest_1.post)('/bestproperty-launches'),
    (0, rest_1.response)(200, {
        description: 'BestpropertyLaunch model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.BestpropertyLaunch) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.BestpropertyLaunch, {
                    title: 'NewBestpropertyLaunch',
                    exclude: ['bestlaunchId '],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], BestpropertylaunchController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/bestproperty-launches/count'),
    (0, rest_1.response)(200, {
        description: 'BestpropertyLaunch model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.BestpropertyLaunch)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], BestpropertylaunchController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/bestproperty-launches'),
    (0, rest_1.response)(200, {
        description: 'Array of BestpropertyLaunch model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.BestpropertyLaunch, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.BestpropertyLaunch)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], BestpropertylaunchController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/bestproperty-launches'),
    (0, rest_1.response)(200, {
        description: 'BestpropertyLaunch PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.BestpropertyLaunch, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.BestpropertyLaunch)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.BestpropertyLaunch, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], BestpropertylaunchController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/bestproperty-launches/{id}'),
    (0, rest_1.response)(200, {
        description: 'BestpropertyLaunch model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.BestpropertyLaunch, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.BestpropertyLaunch, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], BestpropertylaunchController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/bestproperty-launches/{id}'),
    (0, rest_1.response)(204, {
        description: 'BestpropertyLaunch PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.BestpropertyLaunch, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.BestpropertyLaunch]),
    tslib_1.__metadata("design:returntype", Promise)
], BestpropertylaunchController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/bestproperty-launches/{id}'),
    (0, rest_1.response)(204, {
        description: 'BestpropertyLaunch PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.BestpropertyLaunch]),
    tslib_1.__metadata("design:returntype", Promise)
], BestpropertylaunchController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/bestproperty-launches/{id}'),
    (0, rest_1.response)(204, {
        description: 'BestpropertyLaunch DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], BestpropertylaunchController.prototype, "deleteById", null);
exports.BestpropertylaunchController = BestpropertylaunchController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.BestpropertyLaunchRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.BestpropertyLaunchRepository])
], BestpropertylaunchController);
//# sourceMappingURL=bestpropertylaunch.controller.js.map