"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddToCartController = void 0;
const tslib_1 = require("tslib");
/* eslint-disable @typescript-eslint/no-explicit-any */
/* eslint-disable @typescript-eslint/no-unused-vars */
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let AddToCartController = class AddToCartController {
    constructor(addToCartRepository) {
        this.addToCartRepository = addToCartRepository;
    }
    // Helper function to remove unwanted fields from add to cart
    cleanAddToCart(addToCart) {
        const { isDefault, isOn, isActive, createdDate, createdBy, modifiedDate, modifiedBy, deletedDate, deletedBy, deleteRemark, lastChanged, ...cleanedAddToCart } = addToCart;
        return cleanedAddToCart;
    }
    // Helper function to clean nested objects
    cleanNestedObjects(addToCart) {
        // Clean usertype if exists
        if (addToCart.usertype) {
            const { isDefault: userTypeIsDefault, isOn: userTypeIsOn, isActive: userTypeIsActive, createdDate: userTypeCreatedDate, createdBy: userTypeCreatedBy, modifiedDate: userTypeModifiedDate, modifiedBy: userTypeModifiedBy, deletedDate: userTypeDeletedDate, deletedBy: userTypeDeletedBy, deleteRemark: userTypeDeleteRemark, lastChanged: userTypeLastChanged, ...cleanedUsertype } = addToCart.usertype;
            addToCart.usertype = cleanedUsertype;
        }
        // Clean buyer if exists
        if (addToCart.buyer) {
            const { isDefault: buyerIsDefault, isOn: buyerIsOn, isActive: buyerIsActive, createdDate: buyerCreatedDate, createdBy: buyerCreatedBy, modifiedDate: buyerModifiedDate, modifiedBy: buyerModifiedBy, deletedDate: buyerDeletedDate, deletedBy: buyerDeletedBy, deleteRemark: buyerDeleteRemark, lastChanged: buyerLastChanged, ...cleanedBuyer } = addToCart.buyer;
            // Clean nested city if exists
            if (cleanedBuyer.city) {
                const { isDefault: cityIsDefault, isOn: cityIsOn, isActive: cityIsActive, createdDate: cityCreatedDate, createdBy: cityCreatedBy, modifiedDate: cityModifiedDate, modifiedBy: cityModifiedBy, deletedDate: cityDeletedDate, deletedBy: cityDeletedBy, deleteRemark: cityDeleteRemark, lastChanged: cityLastChanged, ...cleanedCity } = cleanedBuyer.city;
                cleanedBuyer.city = cleanedCity;
            }
            // Clean nested gender if exists
            if (cleanedBuyer.gender) {
                const { isDefault: genderIsDefault, isOn: genderIsOn, isActive: genderIsActive, createdDate: genderCreatedDate, createdBy: genderCreatedBy, modifiedDate: genderModifiedDate, modifiedBy: genderModifiedBy, deletedDate: genderDeletedDate, deletedBy: genderDeletedBy, deleteRemark: genderDeleteRemark, lastChanged: genderLastChanged, ...cleanedGender } = cleanedBuyer.gender;
                cleanedBuyer.gender = cleanedGender;
            }
            // Clean nested usertype if exists
            if (cleanedBuyer.usertype) {
                const { isDefault: buyerUserTypeIsDefault, isOn: buyerUserTypeIsOn, isActive: buyerUserTypeIsActive, createdDate: buyerUserTypeCreatedDate, createdBy: buyerUserTypeCreatedBy, modifiedDate: buyerUserTypeModifiedDate, modifiedBy: buyerUserTypeModifiedBy, deletedDate: buyerUserTypeDeletedDate, deletedBy: buyerUserTypeDeletedBy, deleteRemark: buyerUserTypeDeleteRemark, lastChanged: buyerUserTypeLastChanged, ...cleanedBuyerUsertype } = cleanedBuyer.usertype;
                cleanedBuyer.usertype = cleanedBuyerUsertype;
            }
            addToCart.buyer = cleanedBuyer;
        }
        // Clean seller if exists
        if (addToCart.seller) {
            const { isDefault: sellerIsDefault, isOn: sellerIsOn, isActive: sellerIsActive, createdDate: sellerCreatedDate, createdBy: sellerCreatedBy, modifiedDate: sellerModifiedDate, modifiedBy: sellerModifiedBy, deletedDate: sellerDeletedDate, deletedBy: sellerDeletedBy, deleteRemark: sellerDeleteRemark, lastChanged: sellerLastChanged, ...cleanedSeller } = addToCart.seller;
            // Clean nested city if exists
            if (cleanedSeller.city) {
                const { isDefault: cityIsDefault, isOn: cityIsOn, isActive: cityIsActive, createdDate: cityCreatedDate, createdBy: cityCreatedBy, modifiedDate: cityModifiedDate, modifiedBy: cityModifiedBy, deletedDate: cityDeletedDate, deletedBy: cityDeletedBy, deleteRemark: cityDeleteRemark, lastChanged: cityLastChanged, ...cleanedCity } = cleanedSeller.city;
                cleanedSeller.city = cleanedCity;
            }
            // Clean nested package if exists
            if (cleanedSeller.package) {
                const { isDefault: packageIsDefault, isOn: packageIsOn, isActive: packageIsActive, createdDate: packageCreatedDate, createdBy: packageCreatedBy, modifiedDate: packageModifiedDate, modifiedBy: packageModifiedBy, deletedDate: packageDeletedDate, deletedBy: packageDeletedBy, deleteRemark: packageDeleteRemark, lastChanged: packageLastChanged, ...cleanedPackage } = cleanedSeller.package;
                cleanedSeller.package = cleanedPackage;
            }
            // Clean nested user if exists
            if (cleanedSeller.user) {
                const { isDefault: userIsDefault, isOn: userIsOn, isActive: userIsActive, createdDate: userCreatedDate, createdBy: userCreatedBy, modifiedDate: userModifiedDate, modifiedBy: userModifiedBy, deletedDate: userDeletedDate, deletedBy: userDeletedBy, deleteRemark: userDeleteRemark, lastChanged: userLastChanged, ...cleanedUser } = cleanedSeller.user;
                cleanedSeller.user = cleanedUser;
            }
            // Clean nested gender if exists
            if (cleanedSeller.gender) {
                const { isDefault: genderIsDefault, isOn: genderIsOn, isActive: genderIsActive, createdDate: genderCreatedDate, createdBy: genderCreatedBy, modifiedDate: genderModifiedDate, modifiedBy: genderModifiedBy, deletedDate: genderDeletedDate, deletedBy: genderDeletedBy, deleteRemark: genderDeleteRemark, lastChanged: genderLastChanged, ...cleanedGender } = cleanedSeller.gender;
                cleanedSeller.gender = cleanedGender;
            }
            addToCart.seller = cleanedSeller;
        }
        // Clean postProperty if exists
        if (addToCart.postProperty) {
            const { isDefault: postPropertyIsDefault, isOn: postPropertyIsOn, isActive: postPropertyIsActive, createdDate: postPropertyCreatedDate, createdBy: postPropertyCreatedBy, modifiedDate: postPropertyModifiedDate, modifiedBy: postPropertyModifiedBy, deletedDate: postPropertyDeletedDate, deletedBy: postPropertyDeletedBy, deleteRemark: postPropertyDeleteRemark, lastChanged: postPropertyLastChanged, ...cleanedPostProperty } = addToCart.postProperty;
            addToCart.postProperty = cleanedPostProperty;
        }
        return addToCart;
    }
    async create(addToCart) {
        return this.addToCartRepository.create(addToCart);
    }
    async count(where) {
        return this.addToCartRepository.count(where);
    }
    // AddToCartController मध्ये
    async find(filter) {
        // Include usertype, buyer, seller, and postProperty relations
        const enhancedFilter = {
            ...filter,
            include: [
                { relation: 'usertype' },
                { relation: 'buyer' },
                { relation: 'seller' },
                { relation: 'postProperty' }
            ],
        };
        const addToCarts = await this.addToCartRepository.find(enhancedFilter);
        // Clean each add to cart
        const cleanedAddToCarts = addToCarts.map(addToCart => {
            let cleanedAddToCart = this.cleanAddToCart(addToCart);
            cleanedAddToCart = this.cleanNestedObjects(cleanedAddToCart);
            return cleanedAddToCart;
        });
        return cleanedAddToCarts;
    }
    async updateAll(addToCart, where) {
        return this.addToCartRepository.updateAll(addToCart, where);
    }
    async findById(id, filter) {
        // Include usertype, buyer, seller, and postProperty relations
        const enhancedFilter = {
            ...filter,
            include: [
                { relation: 'usertype' },
                { relation: 'buyer' },
                { relation: 'seller' },
                { relation: 'postProperty' }
            ],
        };
        const addToCart = await this.addToCartRepository.findById(id, enhancedFilter);
        // Clean the add to cart
        let cleanedAddToCart = this.cleanAddToCart(addToCart);
        cleanedAddToCart = this.cleanNestedObjects(cleanedAddToCart);
        return cleanedAddToCart;
    }
    async updateById(id, addToCart) {
        await this.addToCartRepository.updateById(id, addToCart);
    }
    async replaceById(id, addToCart) {
        await this.addToCartRepository.replaceById(id, addToCart);
    }
    async deleteById(id) {
        await this.addToCartRepository.deleteById(id);
    }
    // Get cart items by buyer ID
    async findByBuyer(buyerId) {
        const addToCarts = await this.addToCartRepository.find({
            where: {
                fkBuyerIdSellerId: buyerId,
                fkUsertypeId: 1, // Buyer usertype
            },
            include: [
                { relation: 'usertype' },
                { relation: 'buyer' },
                { relation: 'postProperty' }
            ],
        });
        // Clean each add to cart
        return addToCarts.map(addToCart => {
            let cleanedAddToCart = this.cleanAddToCart(addToCart);
            cleanedAddToCart = this.cleanNestedObjects(cleanedAddToCart);
            return cleanedAddToCart;
        });
    }
    // Get cart items by seller ID
    async findBySeller(sellerId) {
        const addToCarts = await this.addToCartRepository.find({
            where: {
                fkBuyerIdSellerId: sellerId,
                fkUsertypeId: { neq: 1 }, // Not buyer (seller or other)
            },
            include: [
                { relation: 'usertype' },
                { relation: 'seller' },
                { relation: 'postProperty' }
            ],
        });
        // Clean each add to cart
        return addToCarts.map(addToCart => {
            let cleanedAddToCart = this.cleanAddToCart(addToCart);
            cleanedAddToCart = this.cleanNestedObjects(cleanedAddToCart);
            return cleanedAddToCart;
        });
    }
    // Get cart count for logged-in user (buyer or seller)
    // Get cart count for logged-in user (buyer or seller)
    async getCartCountByUser(userId, userTypeId) {
        const whereCondition = {
            fkBuyerIdSellerId: userId,
            fkUsertypeId: userTypeId,
            isActive: 1,
        };
        console.log('Cart Count Where:', whereCondition); // 🔍 Debug log
        return this.addToCartRepository.count(whereCondition);
    }
};
exports.AddToCartController = AddToCartController;
tslib_1.__decorate([
    (0, rest_1.post)('/add-to-carts'),
    (0, rest_1.response)(200, {
        description: 'AddToCart model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.AddToCart) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.AddToCart, {
                    title: 'NewAddToCart',
                    exclude: ['addTocartId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], AddToCartController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/add-to-carts/count'),
    (0, rest_1.response)(200, {
        description: 'AddToCart model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.AddToCart)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], AddToCartController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/add-to-carts'),
    (0, rest_1.response)(200, {
        description: 'Array of AddToCart model instances with relations',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.AddToCart, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.AddToCart)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], AddToCartController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/add-to-carts'),
    (0, rest_1.response)(200, {
        description: 'AddToCart PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.AddToCart, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.AddToCart)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.AddToCart, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], AddToCartController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/add-to-carts/{id}'),
    (0, rest_1.response)(200, {
        description: 'AddToCart model instance with relations',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.AddToCart, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.AddToCart, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], AddToCartController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/add-to-carts/{id}'),
    (0, rest_1.response)(204, {
        description: 'AddToCart PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.AddToCart, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.AddToCart]),
    tslib_1.__metadata("design:returntype", Promise)
], AddToCartController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/add-to-carts/{id}'),
    (0, rest_1.response)(204, {
        description: 'AddToCart PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.AddToCart]),
    tslib_1.__metadata("design:returntype", Promise)
], AddToCartController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/add-to-carts/{id}'),
    (0, rest_1.response)(204, {
        description: 'AddToCart DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], AddToCartController.prototype, "deleteById", null);
tslib_1.__decorate([
    (0, rest_1.get)('/add-to-carts/buyer/{buyerId}'),
    (0, rest_1.response)(200, {
        description: 'Array of AddToCart for a specific buyer',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.AddToCart, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('buyerId')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], AddToCartController.prototype, "findByBuyer", null);
tslib_1.__decorate([
    (0, rest_1.get)('/add-to-carts/seller/{sellerId}'),
    (0, rest_1.response)(200, {
        description: 'Array of AddToCart for a specific seller',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.AddToCart, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('sellerId')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], AddToCartController.prototype, "findBySeller", null);
tslib_1.__decorate([
    (0, rest_1.get)('/add-to-carts/user/{userId}/{userTypeId}/count'),
    (0, rest_1.response)(200, {
        description: 'Cart item count for logged-in user',
        content: {
            'application/json': { schema: repository_1.CountSchema },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('userId')),
    tslib_1.__param(1, rest_1.param.path.number('userTypeId')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Number]),
    tslib_1.__metadata("design:returntype", Promise)
], AddToCartController.prototype, "getCartCountByUser", null);
exports.AddToCartController = AddToCartController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.AddToCartRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.AddToCartRepository])
], AddToCartController);
//# sourceMappingURL=add-to-cart.controller.js.map