import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { AddToCart, AddToCartRelations } from '../models';
import { AddToCartRepository } from '../repositories';
export declare class AddToCartController {
    addToCartRepository: AddToCartRepository;
    constructor(addToCartRepository: AddToCartRepository);
    private cleanAddToCart;
    private cleanNestedObjects;
    create(addToCart: Omit<AddToCart, 'addTocartId'>): Promise<AddToCart>;
    count(where?: Where<AddToCart>): Promise<Count>;
    find(filter?: Filter<AddToCart>): Promise<(AddToCart & AddToCartRelations)[]>;
    updateAll(addToCart: AddToCart, where?: Where<AddToCart>): Promise<Count>;
    findById(id: number, filter?: FilterExcludingWhere<AddToCart>): Promise<AddToCart & AddToCartRelations>;
    updateById(id: number, addToCart: AddToCart): Promise<void>;
    replaceById(id: number, addToCart: AddToCart): Promise<void>;
    deleteById(id: number): Promise<void>;
    findByBuyer(buyerId: number): Promise<(AddToCart & AddToCartRelations)[]>;
    findBySeller(sellerId: number): Promise<(AddToCart & AddToCartRelations)[]>;
    getCartCountByUser(userId: number, userTypeId: number): Promise<Count>;
}
